<?php

namespace Layerdrops\Oxpins\Widgets;


class FooterContact extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'footer-contact';
    }

    public function get_title()
    {
        return __('Footer Contact', 'oxpins-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['oxpins-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'oxpins-addon'),
                ]
            ]
        );


        $this->end_controls_section();


        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Widget Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Contact', 'oxpins-addon'),
                'label_block' => true
            ]
        );

        $this->add_control(
            'about_text',
            [
                'label' => __('About Text', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Default Text', 'oxpins-addon'),
                'label_block' => true
            ]
        );

        $items = new \Elementor\Repeater();

        $items->add_control(
            'icon',
            [
                'label' => __('Select Icon', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fa fa-envelope',
                    'library' => 'custom',
                ],
            ]
        );

        $items->add_control(
            'content',
            [
                'label' => __('Content'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'label_block' => true,
                'default' => wp_kses(__('<a href="mailto:needhelp@company.com ">needhelp@company.com</a>', 'oxpins-addon'), 'oxpins_allowed_tags')
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => __('Contact Info', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $items->get_controls(),
                'prevent_empty' => false,
            ]
        );

        $social_icons = new \Elementor\Repeater();

        $social_icons->add_control(
            'social_icon',
            [
                'label' => __('Select Icon', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-facebook-f',
                    'library' => 'brands',
                ],
            ]
        );

        $social_icons->add_control(
            'social_url',
            [
                'label' => __('Add Url', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'oxpins-addon'),
                'show_external' => false,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'show_label' => false,
            ]
        );

        $this->add_control(
            'social_icons',
            [
                'label' => __('Social Icons', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $social_icons->get_controls(),
                'prevent_empty' => false,
                'default' => [
                    [
                        'social_url' => [
                            'url' => '#',
                            'is_external' => false,
                            'nofollow' => false,
                        ],
                    ],
                ],
            ]
        );

        $this->end_controls_section();

        //style layout one
        $this->start_controls_section(
            'style_options',
            [
                'label' => esc_html__('Style Options', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        oxpins_typo_and_color_options($this, 'Title', '{{WRAPPER}} .footer-widget__title', ['layout_one']);
        oxpins_typo_and_color_options($this, 'About Text', '{{WRAPPER}} .footer-widget__contact-text', ['layout_one']);
        oxpins_typo_and_color_options($this, 'Info Content', '{{WRAPPER}} .footer-widget__contact-list li .text p a', ['layout_one']);
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include oxpins_get_template('footer-contact-one.php');
    }
}
