<?php

namespace Layerdrops\Oxpins\Widgets;


class Funfact extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'oxpins-funfact';
    }

    public function get_title()
    {
        return __('Funfact', 'oxpins-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['oxpins-category'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'oxpins-addon'),
                ]
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $funfact_box = new \Elementor\Repeater();

        $funfact_box->add_control(
            'counter',
            [
                'label' => __('Count Number', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => 70,
                'label_block' => true,
            ]
        );



        $funfact_box->add_control(
            'sign',
            [
                'label' => __('Sign', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('M', 'oxpins-addon'),
                'label_block' => true,
            ]
        );

        $funfact_box->add_control(
            'text',
            [
                'label' => __('Count Text', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Total Campaigns', 'oxpins-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'funfact_boxes',
            [
                'label' => __('Funfact Boxes', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'prevent_empty' => false,
                'fields' => $funfact_box->get_controls(),
                'default' => [
                    [
                        'counter' => 4850,
                        'text' => __('Total Campaigns', 'oxpins-addon'),
                        'icon' => [
                            'value' => 'icon-campaign',
                            'library' => 'custom-icon',
                        ],
                    ],
                ],
                'title_field' => '{{{ text }}}',
            ]
        );

        $this->add_control(
            'bg_image',
            [
                'label' => __('Add Background Image', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $this->end_controls_section();


        //style
        $this->start_controls_section(
            'style_options',
            [
                'label' => esc_html__('Style Options', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        oxpins_typo_and_color_options($this, 'Text', '{{WRAPPER}} .counter-one__text', ['layout_one']);
        oxpins_typo_and_color_options($this, 'Number', '{{WRAPPER}} .counter-one__single h3', ['layout_one']);
        oxpins_typo_and_color_options($this, 'Sign', '{{WRAPPER}} .counter-one__letter', ['layout_one']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include oxpins_get_template('funfact-one.php');
    }
}
