<?php

namespace Layerdrops\Oxpins\Widgets;


class Gallery extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'oxpins-gallery';
    }

    public function get_title()
    {
        return __('Gallery', 'oxpins-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['oxpins-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'oxpins-addon'),
                    'layout_two' => __('Layout Two', 'oxpins-addon'),
                    'layout_three' => __('Layout Three', 'oxpins-addon'),
                    'layout_four' => __('Layout Four', 'oxpins-addon'),
                ]
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'sec_title',
            [
                'label' => __('Section Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Our photo gallery', 'oxpins-addon'),
                'label_block' => true,
                'condition' => [
                    'layout_type' => ['layout_one']
                ],
            ]
        );

        $gallery_images = new \Elementor\Repeater();

        $gallery_images->add_control(
            'image',
            [
                'label' => __('Add Image', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $gallery_images->add_control(
            'title',
            [
                'label' => __('Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Education', 'oxpins-addon'),
                'label_block' => true
            ]
        );


        $gallery_images->add_control(
            'sub_title',
            [
                'label' => __('Sub Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Charity', 'oxpins-addon'),
                'label_block' => true
            ]
        );


        $this->add_control(
            'gallery_images',
            [
                'label' => __('Gallery Items', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'prevent_empty' => false,
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_two', 'layout_three', 'layout_four']
                ],
                'fields' => $gallery_images->get_controls(),
            ]
        );

        $this->end_controls_section();

        //style
        $this->start_controls_section(
            'style_options',
            [
                'label' => esc_html__('Style Options', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        oxpins_typo_and_color_options($this, 'Section Title', '{{WRAPPER}} .gallery-one__top-title', ['layout_one']);

        oxpins_typo_and_color_options($this, 'Title', '{{WRAPPER}} .gallery-one__title,{{WRAPPER}} .gallery-page__title', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);
        oxpins_typo_and_color_options($this, 'Sub Title', '{{WRAPPER}} .gallery-one__sub-title,{{WRAPPER}} .gallery-page__sub-title', ['layout_one', 'layout_two', 'layout_three', 'layout_four']);


        $this->end_controls_section();

        oxpins_get_elementor_carousel_options($this, ['layout_four']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include oxpins_get_template('gallery-one.php');
        include oxpins_get_template('gallery-two.php');
        include oxpins_get_template('gallery-three.php');
        include oxpins_get_template('gallery-four.php');
    }
}
