<?php

namespace Layerdrops\Oxpins\Widgets;


class GiveForms extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'oxpins-give-forms';
    }

    public function get_title()
    {
        return __('Give Forms', 'oxpins-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['oxpins-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'oxpins-addon'),
                    'layout_two' => __('Layout Two', 'oxpins-addon'),
                    'layout_three' => __('Layout Three', 'oxpins-addon'),
                    'layout_four' => __('Layout Four', 'oxpins-addon'),
                    'layout_five' => __('Layout Five', 'oxpins-addon'),
                    'layout_six' => __('Layout Six', 'oxpins-addon'),
                    'layout_seven' => __('Layout Seven', 'oxpins-addon'),
                    'layout_eight' => __('Layout Eight', 'oxpins-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content',
            [
                'label' => __('Content', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => __('Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Add Title', 'oxpins-addon'),
                'default' => __('Default Title', 'oxpins-addon'),
                'condition'   => [
                    'layout_type' => ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']
                ]
            ]
        );

        $this->add_control(
            'sub_title',
            [
                'label' => __('Sub Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Add Sub Title', 'oxpins-addon'),
                'default' => __('Default Sub Title', 'oxpins-addon'),
                'condition'   => [
                    'layout_type' => ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']
                ]
            ]
        );

        $this->add_control(
            'summary',
            [
                'label' => __('Summary', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Add Summary', 'oxpins-addon'),
                'default' => __('Default Summary Text', 'oxpins-addon'),
                'condition'   => [
                    'layout_type' => ['layout_two', 'layout_three']
                ]
            ]
        );

        $this->add_control(
            'btn_label',
            [
                'label' => __('Button Label', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Button Label', 'oxpins-addon'),
                'default' => __('Donate now', 'oxpins-addon'),
                'label_block' => true,
                'condition'   => [
                    'layout_type' => ['layout_three', 'layout_four']
                ]
            ]
        );


        $this->add_control(
            'progress_bar_bg',
            [
                'label' => __('Progress Bar Background', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'condition'   => [
                    'layout_type' => ['layout_one', 'layout_two', 'layout_five', 'layout_six', 'layout_seven', 'layout_eight']
                ]
            ]
        );

        $this->add_control(
            'bg_image',
            [
                'label' => __('Background Image', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'condition'   => [
                    'layout_type' => ['layout_three', 'layout_five']
                ]
            ]
        );

        $this->add_control(
            'bg_shape',
            [
                'label' => __('Background Shape', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'condition'   => [
                    'layout_type' => ['layout_two', 'layout_five']
                ]
            ]
        );


        $this->add_control(
            'icon',
            [
                'label' => __('Button Icon', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fa fa-heart',
                    'library' => 'custom-icon',
                ],
                'condition'   => [
                    'layout_type' => ['layout_three']
                ]
            ]
        );

        $layout_four_info = new \Elementor\Repeater();

        $layout_four_info->add_control(
            'icon',
            [
                'label' => __('Icon', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-calendar-alt',
                    'library' => 'custom-icon',
                ],
            ]
        );

        $layout_four_info->add_control(
            'content',
            [
                'label' => __('Content', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('45 Days Left', 'oxpins-addon'),
                'label_block' => true,
            ]
        );

        $layout_four_info->add_control(
            'url',
            [
                'label' => __('Url', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'oxpins-addon'),
                'show_external' => false,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'show_label' => false,
            ]
        );

        $this->add_control(
            'layout_two_info_box_items',
            [
                'label' => __('Info Boxes', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $layout_four_info->get_controls(),
                'prevent_empty' => false,
                'condition' => [
                    'layout_type' => 'layout_four'
                ],
                'title_field' => '{{{ content }}}',
            ]
        );

        $this->add_control(
            'raised_icon',
            [
                'label' => __('Raised Icon', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'far fa-hand-paper',
                    'library' => 'custom-icon',
                ],
                'condition'   => [
                    'layout_type' => ['layout_four']
                ]
            ]
        );

        $this->add_control(
            'currency_type',
            [
                'label' => __('Currency Type', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('$', 'oxpins-addon'),
                'label_block' => true,
                'condition'   => [
                    'layout_type' => ['layout_four']
                ]
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'post_options',
            [
                'label' => __('Post Options', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'query_order',
            [
                'label' => __('Select Order', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'DESC',
                'options' => [
                    'DESC' => __('DESC', 'oxpins-addon'),
                    'ASC' => __('ASC', 'oxpins-addon'),
                ],
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_two', 'layout_five', 'layout_six', 'layout_seven', 'layout_eight']
                ]
            ]
        );

        $this->add_control(
            'post_count',
            [
                'label' => __('Number Of Posts', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['count'],
                'range' => [
                    'count' => [
                        'min' => 0,
                        'max' => 15,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'count',
                    'size' => 6,
                ],
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_two', 'layout_five', 'layout_six', 'layout_seven', 'layout_eight']
                ]
            ]
        );

        $this->add_control(
            'select_category',
            [
                'label' => __('Post Category', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => oxpins_get_taxonoy('give_forms_category'),
                'multiple' => true,
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_two', 'layout_five', 'layout_six', 'layout_seven', 'layout_eight']
                ]
            ]
        );

        $this->add_control(
            'post_word_count',
            [
                'label' => __('Word Count In Excerpt', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['count'],
                'range' => [
                    'count' => [
                        'min' => 1,
                        'max' => 200,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'count',
                    'size' => 11,
                ],
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_two', 'layout_five', 'layout_six', 'layout_seven', 'layout_eight']
                ]
            ]
        );

        $this->add_control(
            'pagination_status',
            [
                'label' => __('Enable Pagination?', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'oxpins-addon'),
                'label_off' => __('No', 'oxpins-addon'),
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => [
                    'layout_type' => ['layout_five', 'layout_six', 'layout_seven']
                ]

            ]
        );

        $this->add_control(
            'select_give_form',
            [
                'label'       => esc_html__('Select Your Donation Form', 'oxpins-addon'),
                'label_block' => true,
                'type'        => \Elementor\Controls_Manager::SELECT,
                'options'     => oxpins_post_query('give_forms'),
                'condition' => [
                    'layout_type' => ['layout_three', 'layout_four']
                ]
            ]
        );


        $this->add_control(
            'layout_four_image',
            [
                'label' => __('Image', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'condition'   => [
                    'layout_type' => 'layout_four'
                ]
            ]
        );

        $this->end_controls_section();


        //style
        $this->start_controls_section(
            'style_options',
            [
                'label' => esc_html__('Style Options', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );


        oxpins_typo_and_color_options($this, 'Section Title', '{{WRAPPER}} .section-title__title, {{WRAPPER}} .make-donation__title', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);
        oxpins_typo_and_color_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline,{{WRAPPER}} .make-donation__text', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);
        oxpins_typo_and_color_options($this, 'Section Summary', '{{WRAPPER}} .causes-two-top__text', ['layout_two']);

        oxpins_typo_and_color_options($this, 'Title', '{{WRAPPER}} .causes-one__title a,{{WRAPPER}} .donations-list__title a', ['layout_one', 'layout_two', 'layout_five', 'layout_six', 'layout_seven', 'layout_eight']);

        oxpins_typo_and_color_options($this, 'Summary Text', '{{WRAPPER}} .causes-one__text, {{WRAPPER}} .urgent-cause__top-text, {{WRAPPER}} .donations-list__text', ['layout_one', 'layout_two', 'layout_three', 'layout_five', 'layout_six', 'layout_seven', 'layout_eight']);

        oxpins_typo_and_color_options($this, 'Category', '{{WRAPPER}} .causes-one__cat p,{{WRAPPER}} .donations-list__category p', ['layout_one', 'layout_two', 'layout_five', 'layout_six', 'layout_seven', 'layout_eight']);

        oxpins_typo_and_color_options($this, 'Info Content', '{{WRAPPER}} .make-donation__meta li a', ['layout_four']);

        oxpins_typo_and_color_options($this, 'Button', '{{WRAPPER}} .urgent-cause__btn a,{{WRAPPER}} .make-donation__btn', ['layout_three', 'layout_four']);
        oxpins_typo_and_color_options($this, 'Button Background', '{{WRAPPER}} .urgent-cause__btn a,{{WRAPPER}} .make-donation__btn', ['layout_three', 'layout_four'], 'background-color', false);
        $this->end_controls_section();

        oxpins_get_elementor_carousel_options($this, ['layout_eight']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include oxpins_get_template('give-forms-one.php');
        include oxpins_get_template('give-forms-two.php');
        include oxpins_get_template('give-forms-three.php');
        include oxpins_get_template('give-forms-four.php');
        include oxpins_get_template('give-forms-five.php');
        include oxpins_get_template('give-forms-six.php');
        include oxpins_get_template('give-forms-seven.php');
        include oxpins_get_template('give-forms-eight.php');
    }
}
