<?php

namespace Layerdrops\Oxpins\Widgets;


class Header extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'oxpins-header';
    }

    public function get_title()
    {
        return __('Header', 'oxpins-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['oxpins-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout Type', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'oxpins-addon'),
                    'layout_two' => __('Layout Two', 'oxpins-addon'),
                    'layout_three' => __('Layout Three', 'oxpins-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'logo_section',
            [
                'label' => __('Site Logo', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'light_logo',
            [
                'label' => __('Light Logo', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );


        $this->add_control(
            'dark_logo',
            [
                'label' => __('Dark Logo', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'logo_dimension',
            [
                'label' => __('Logo Dimension', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::IMAGE_DIMENSIONS,
                'description' => __('Set Custom Logo Size.', 'oxpins-addon'),
                'default' => [
                    'width' => '150',
                    'height' => '50',
                ],
            ]
        );

        $this->add_control(
            'logo_shape',
            [
                'label' => __('Logo Shape', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'nav_section',
            [
                'label' => __('Navigation', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'one_page_status',
            [
                'label' => __('Enable One Page Menu?', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'oxpins-addon'),
                'label_off' => __('No', 'oxpins-addon'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'nav_menu',
            [
                'label' => __('Select Nav Menu', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => oxpins_get_nav_menu(),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'top_bar_section',
            [
                'label' => __('Top Bar', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'top_bar_left_content',
            [
                'label' => __('Top Bar Left Content'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Become a volunteers', 'oxpins-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'top_bar_left_content_icon',
            [
                'label' => __('Left Content Icon Image', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );


        $this->add_control(
            'top_bar_left_content_url',
            [
                'label' => __('Left Content Url', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'label_block' => true
            ]
        );

        $top_bar_right_content = new \Elementor\Repeater();

        $top_bar_right_content->add_control(
            'icon',
            [
                'label' => __('Select Icon', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'icon-phone-call',
                    'library' => 'custom-icon',
                ],
            ]
        );

        $top_bar_right_content->add_control(
            'title',
            [
                'label' => __('Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'label_block' => true,
                'default' => __('Helpline', 'oxpins-addon')
            ]
        );

        $top_bar_right_content->add_control(
            'content',
            [
                'label' => __('Content', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => wp_kses(__('<a href="tel:980009630">+ 98 (000) - 9630</a>', 'oxpins-addon'), 'oxpins_allowed_tags'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'top_bar_right_content',
            [
                'label' => __('Top Bar Info Items', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $top_bar_right_content->get_controls(),
                'prevent_empty' => false,
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_two']
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'others_section',
            [
                'label' => __('Others', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'search_status',
            [
                'label' => __('Enable Search?', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'oxpins-addon'),
                'label_off' => __('No', 'oxpins-addon'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_control(
            'cart_status',
            [
                'label' => __('Enable Cart?', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'oxpins-addon'),
                'label_off' => __('No', 'oxpins-addon'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'login',
            [
                'label' => __('Enable Login?', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'oxpins-addon'),
                'label_off' => __('No', 'oxpins-addon'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );

        $this->add_control(
            'login_url',
            [
                'label' => __('Login Url', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'label_block' => true,
                'condition' => [
                    'login' => 'yes'
                ]
            ]
        );

        $this->add_control(
            'call_Icon',
            [
                'label' => __('Call Icon', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'condition' => [
                    'layout_type' => 'layout_three'
                ],
                'default' => [
                    'value' => 'fas fa-phone',
                    'library' => 'custom-icon',
                ],
            ]
        );

        $this->add_control(
            'call_number',
            [
                'label' => __('Call Number', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('+ 98 (000) - 9630', 'oxpins-addon'),
                'label_block' => true,
                'condition' => [
                    'layout_type' => 'layout_three'
                ]
            ]
        );

        $this->add_control(
            'call_url',
            [
                'label' => __('Call Url', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => '#',
                'label_block' => true,
                'condition' => [
                    'layout_type' => 'layout_three'
                ]
            ]
        );


        $this->add_control(
            'btn_text',
            [
                'label' => __('Button text', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Donate Now', 'oxpins-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'btn_url',
            [
                'label' => __('Button Url', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'label_block' => true,
            ]
        );

        $social_icons = new \Elementor\Repeater();

        $social_icons->add_control(
            'social_icon',
            [
                'label' => __('Select Icon', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-facebook-f',
                    'library' => 'brands',
                ],
            ]
        );

        $social_icons->add_control(
            'social_url',
            [
                'label' => __('Add Url', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'oxpins-addon'),
                'show_external' => false,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'show_label' => false,
            ]
        );

        $this->add_control(
            'social_icons',
            [
                'label' => __('Social Icons', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $social_icons->get_controls(),
                'prevent_empty' => false,
                'condition' => [
                    'layout_type' => ['layout_one', 'layout_two']
                ],
                'default' => [
                    [
                        'social_url' => [
                            'url' => '#',
                            'is_external' => false,
                            'nofollow' => false,
                        ],
                    ],
                ],
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'mobile_menu_section',
            [
                'label' => __('Mobile Drawer', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
            'mobile_menu_logo',
            [
                'label' => __('Mobile Drawer Logo', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );



        $this->add_control(
            'mobile_menu_email',
            [
                'label' => __('Email Address', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('email@eamil.com', 'oxpins-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'mobile_menu_phone',
            [
                'label' => __('Phone Number', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('323232', 'oxpins-addon'),
                'label_block' => true,
            ]
        );

        $mobile_menu_social_icons = new \Elementor\Repeater();

        $mobile_menu_social_icons->add_control(
            'social_icon',
            [
                'label' => __('Select Icon', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fab fa-facebook-f',
                    'library' => 'brands',
                ],
                'label_block' => true,
            ]
        );

        $mobile_menu_social_icons->add_control(
            'social_url',
            [
                'label' => __('Add Url', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'oxpins-addon'),
                'show_external' => false,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'show_label' => false,
            ]
        );

        $this->add_control(
            'mobile_menu_social_icons',
            [
                'label' => __('Social Icons', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $mobile_menu_social_icons->get_controls(),
                'prevent_empty' => false,
                'default' => [
                    [
                        'social_icon' => 'fa-facebook-f',
                        'social_url' => [
                            'url' => '#',
                            'is_external' => false,
                            'nofollow' => false,
                        ],
                    ],
                ],
            ]
        );

        $this->end_controls_section();

        //style
        $this->start_controls_section(
            'style_ooptions',
            [
                'label' => esc_html__('Style Options', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        oxpins_typo_and_color_options($this, 'Nav Menu', '{{WRAPPER}} .main-menu .main-menu__list > li > a, .stricky-header .main-menu__list > li > a', ['layout_one', 'layout_two', 'layout_three']);
        oxpins_typo_and_color_options($this, 'Call Number', '{{WRAPPER}} .main-menu-three__number a', ['layout_three']);
        oxpins_typo_and_color_options($this, 'Top Bar Left Content', '{{WRAPPER}} .main-menu__volunteers-text,{{WRAPPER}} .main-menu-two__volunteers-text', ['layout_one', 'layout_two']);
        oxpins_typo_and_color_options($this, 'Top Bar Info Title', '{{WRAPPER}} .main-menu__right-top-address-list li .content p,{{WRAPPER}} .main-menu-two__right-top-address-list li .content p', ['layout_one', 'layout_two']);
        oxpins_typo_and_color_options($this, 'Top Bar Info Content', '{{WRAPPER}} .main-menu__right-top-address-list li .content h5 a,{{WRAPPER}} .main-menu-two__right-top-address-list li .content h5 a', ['layout_one', 'layout_two']);
        oxpins_typo_and_color_options($this, 'Button', '{{WRAPPER}} .main-menu__btn, {{WRAPPER}} .main-menu-two__btn, {{WRAPPER}} .main-menu-three__btn', ['layout_one', 'layout_two', 'layout_three']);
        oxpins_typo_and_color_options($this, 'Button Background', '{{WRAPPER}} .main-menu__btn, {{WRAPPER}} .main-menu__btn:before, {{WRAPPER}} .main-menu-two__btn, {{WRAPPER}} .main-menu-three__btn', ['layout_one', 'layout_two', 'layout_three'], 'background-color', false);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include oxpins_get_template('header.php');
    }
}
