<?php

namespace Layerdrops\Oxpins\Widgets;


class InfoBox extends \Elementor\Widget_Base
{
	public function get_name()
	{
		return 'oxpins-info-box';
	}

	public function get_title()
	{
		return __('Info Box', 'oxpins-addon');
	}

	public function get_icon()
	{
		return 'eicon-cogs';
	}

	public function get_categories()
	{
		return ['oxpins-category'];
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'oxpins-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'oxpins-addon'),
					'layout_two' => __('Layout Two', 'oxpins-addon'),
					'layout_three' => __('Layout Three', 'oxpins-addon'),
				]
			]
		);


		$this->end_controls_section();

		$this->start_controls_section(
			'content_section',
			[
				'label' => __('Content', 'oxpins-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);


		$layout_one_item = new \Elementor\Repeater();

		$layout_one_item->add_control(
			'icon',
			[
				'label' => __('Count Icon', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'icon-charity',
					'library' => 'custom-icon',
				],
			]
		);

		$layout_one_item->add_control(
			'title',
			[
				'label' => __('Title', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Become a volunteer	', 'oxpins-addon'),
				'label_block' => true,
			]
		);


		$layout_one_item->add_control(
			'url',
			[
				'label' => __('Url', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::URL,
				'placeholder' => __('#', 'oxpins-addon'),
				'show_external' => false,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
			]
		);

		$layout_one_item->add_control(
			'summary',
			[
				'label' => __('Summary', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => __('Summary Text', 'oxpins-addon'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'info_box_items',
			[
				'label' => __('Info Boxes', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $layout_one_item->get_controls(),
				'prevent_empty' => false,
				'condition' => [
					'layout_type' => 'layout_one'
				],
				'default' => [
					[
						'title' => __('Support', 'oxpins-addon'),
					],
				],
				'title_field' => '{{{ title }}}',
			]
		);


		$layout_two_item = new \Elementor\Repeater();

		$layout_two_item->add_control(
			'icon',
			[
				'label' => __('Icon', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'icon-phone-call',
					'library' => 'custom-icon',
				],
			]
		);

		$layout_two_item->add_control(
			'title',
			[
				'label' => __('Title', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Helpline', 'oxpins-addon'),
				'label_block' => true,
			]
		);

		$layout_two_item->add_control(
			'content',
			[
				'label' => __('Content', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXTAREA,
				'default' => wp_kses(__('<a href="tel:980009630">+ 98 (000) - 9630</a>', 'oxpins-addon'), 'oxpins_allowed_tags'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'layout_two_info_box_items',
			[
				'label' => __('Info Boxes', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $layout_two_item->get_controls(),
				'prevent_empty' => false,
				'condition' => [
					'layout_type' => 'layout_two'
				],
				'default' => [
					[
						'title' => __('Helpline', 'oxpins-addon'),
					],
				],
				'title_field' => '{{{ title }}}',
			]
		);

		$layout_three_item = new \Elementor\Repeater();

		$layout_three_item->add_control(
			'icon',
			[
				'label' => __('Count Icon', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::ICONS,
				'default' => [
					'value' => 'icon-bonus',
					'library' => 'custom-icon',
				],
			]
		);

		$layout_three_item->add_control(
			'title',
			[
				'label' => __('Title', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __('Awesome title', 'oxpins-addon'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'layout_three_info_box_items',
			[
				'label' => __('Info Boxes', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $layout_three_item->get_controls(),
				'prevent_empty' => false,
				'condition' => [
					'layout_type' => 'layout_three'
				],
				'default' => [
					[
						'title' => __('Default Title', 'oxpins-addon'),
					],
				],
				'title_field' => '{{{ title }}}',
			]
		);

		$this->add_control(
			'search_status',
			[
				'label' => __('Enable Search Form?', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => __('Yes', 'oxpins-addon'),
				'label_off' => __('No', 'oxpins-addon'),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'layout_type' => 'layout_three'
				]
			]
		);


		$this->add_control(
			'layout_three_background_image',
			[
				'label' => __('Add Background Image', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
				'condition' => [
					'layout_type' => 'layout_three'
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'bg_shape',
			[
				'label' => __('Background ', 'oxpins-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'layout_type' => 'layout_one'
				]
			]
		);

		$this->add_control(
			'background_image',
			[
				'label' => __('Add Background Image', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);

		$this->add_control(
			'background_shape',
			[
				'label' => __('Add Background Shape', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);

		$this->end_controls_section();

		//style layout one
		$this->start_controls_section(
			'style_options',
			[
				'label' => esc_html__('Style Options', 'oxpins-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		oxpins_typo_and_color_options($this, 'Info Box Title', '{{WRAPPER}} .help__title a,{{WRAPPER}} .contact-one__sub-title,{{WRAPPER}}  .feature-four__title', ['layout_one', 'layout_two', 'layout_three']);
		oxpins_typo_and_color_options($this, 'Info Box Content', '{{WRAPPER}} .help__text,{{WRAPPER}} .contact-one__number a,{{WRAPPER}} .contact-one__number', ['layout_one', 'layout_two']);
		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include oxpins_get_template('info-box-one.php');
		include oxpins_get_template('info-box-two.php');
		include oxpins_get_template('info-box-three.php');
	}
}
