<?php

namespace Layerdrops\Oxpins\Widgets;


class Shape extends \Elementor\Widget_Base
{
	public function get_name()
	{
		return 'oxpins-shape';
	}

	public function get_title()
	{
		return __('Shape', 'oxpins-addon');
	}

	public function get_icon()
	{
		return 'eicon-cogs';
	}

	public function get_categories()
	{
		return ['oxpins-category'];
	}

	protected function register_controls()
	{
		$this->start_controls_section(
			'layout_section',
			[
				'label' => __('Layout', 'oxpins-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'layout_type',
			[
				'label' => __('Select Layout', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::SELECT2,
				'default' => 'layout_one',
				'options' => [
					'layout_one' => __('Layout One', 'oxpins-addon'),
				]
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'layout_one_content_section',
			[
				'label' => __('Content', 'oxpins-addon'),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
				'condition' => [
					'layout_type' => ['layout_one']
				]
			]
		);

		$this->add_control(
			'shape_one',
			[
				'label' => __('Shape One', 'oxpins-addon'),
				'type' => \Elementor\Controls_Manager::MEDIA,
				'default' => [],
			]
		);

		$this->end_controls_section();
	}

	protected function render()
	{
		$settings = $this->get_settings_for_display();
		include oxpins_get_template('shape-one.php');
	}
}
