<?php

namespace Layerdrops\Oxpins\Widgets;


class SidebarBlog extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'oxpins-sidebar-blog';
    }

    public function get_title()
    {
        return __('Sidebar Blog', 'oxpins-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['oxpins-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'oxpins-addon'),
                ]
            ]
        );


        $this->add_control(
            'title',
            [
                'label' => __('Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Add Title', 'oxpins-addon'),
                'default' => __('Default Title', 'oxpins-addon'),
            ]
        );

        $this->add_control(
            'background_image',
            [
                'label' => __('Background Image', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Post Options', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
            'post_count',
            [
                'label' => __('Number Of Posts', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['count'],
                'range' => [
                    'count' => [
                        'min' => 0,
                        'max' => 15,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'count',
                    'size' => 6,
                ],
            ]
        );

        $this->add_control(
            'post_word_count',
            [
                'label' => __('Word Count In Excerpt', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['count'],
                'range' => [
                    'count' => [
                        'min' => 1,
                        'max' => 200,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'count',
                    'size' => 11,
                ],
                'condition' => [
                    'layout_type' => 'layout_one'
                ]
            ]
        );

        $this->add_control(
            'query_order',
            [
                'label' => __('Select Order', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'DESC',
                'options' => [
                    'DESC' => __('DESC', 'oxpins-addon'),
                    'ASC' => __('ASC', 'oxpins-addon'),
                ]
            ]
        );

        $this->add_control(
            'select_category',
            [
                'label' => __('Post Category', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'options' => oxpins_get_taxonoy('category'),

            ]
        );

        $this->end_controls_section();

        //style
        $this->start_controls_section(
            'style_options',
            [
                'label' => esc_html__('Style Options', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        oxpins_typo_and_color_options($this, 'Section Title', '{{WRAPPER}} .sidebar__post .sidebar__title', ['layout_one']);

        oxpins_typo_and_color_options($this, 'Post Title', '{{WRAPPER}} .sidebar__post-content h3 a', ['layout_one']);
        oxpins_typo_and_color_options($this, 'Post Meta', '{{WRAPPER}} .sidebar__post-content h3 span.sidebar__post-content-meta', ['layout_one']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include oxpins_get_template('sidebar-blog-one.php');
    }
}
