<?php

namespace Layerdrops\Oxpins\Widgets;


class SidebarSocialShare extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'oxpins-sidebar-social-share';
    }

    public function get_title()
    {
        return __('Sidebar Social Share', 'oxpins-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['oxpins-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'oxpins-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Post Options', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->add_control(
            'title',
            [
                'label' => __('Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'placeholder' => __('Add Title', 'oxpins-addon'),
                'default' => __('Share', 'oxpins-addon'),
            ]
        );

        $this->add_control(
            'background_image',
            [
                'label' => __('Add Background Image', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $this->end_controls_section();

        //style
        $this->start_controls_section(
            'style_options',
            [
                'label' => esc_html__('Style Options', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        oxpins_typo_and_color_options($this, 'Section Title', '{{WRAPPER}} .donation-details__sidebar-shaare-cause-title', ['layout_one']);

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include oxpins_get_template('sidebar-social-share.php');
    }
}
