<?php

namespace Layerdrops\Oxpins\Widgets;


class Sponsors extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'oxpins-sponsors';
    }

    public function get_title()
    {
        return __('Sponsors', 'oxpins-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['oxpins-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'oxpins-addon'),
                    'layout_two' => __('Layout Two', 'oxpins-addon'),
                    'layout_three' => __('Layout Three', 'oxpins-addon'),
                ]
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $sponsor_images = new \Elementor\Repeater();

        $sponsor_images->add_control(
            'image',
            [
                'label' => __('Add Image', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
            ]
        );

        $sponsor_images->add_control(
            'link',
            [
                'label' => __('Add Link', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
            ]
        );


        $this->add_control(
            'sponsor_images',
            [
                'label' => __('Sponsor Items', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'prevent_empty' => false,
                'fields' => $sponsor_images->get_controls(),
            ]
        );

        $this->add_control(
            'bg_image',
            [
                'label' => __('Background Image', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'condition' => [
                    'layout_type' => ['layout_two', 'layout_three']
                ]
            ]
        );

        $this->end_controls_section();

        oxpins_get_elementor_carousel_options($this, ['layout_one', 'layout_two', 'layout_three']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include oxpins_get_template('sponsors-one.php');
        include oxpins_get_template('sponsors-two.php');
        include oxpins_get_template('sponsors-three.php');
    }
}
