<?php

namespace Layerdrops\Oxpins\Widgets;


class Team extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'oxpins-team';
    }

    public function get_title()
    {
        return __('Team', 'oxpins-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['oxpins-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'oxpins-addon'),
                    'layout_two' => __('Layout Two', 'oxpins-addon'),
                    'layout_three' => __('Layout Three', 'oxpins-addon'),
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'sec_title',
            [
                'label' => __('Section Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Add Title', 'oxpins-addon'),
                'default' => __('Default Title', 'oxpins-addon'),
                'condition' => [
                    'layout_type' => 'layout_one'
                ]
            ]
        );

        $this->add_control(
            'sec_sub_title',
            [
                'label' => __('Section Sub Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Add Sub Title', 'oxpins-addon'),
                'default' => __('Default Sub Title', 'oxpins-addon'),
                'condition' => [
                    'layout_type' => 'layout_one'
                ]
            ]
        );

        $team_items = new \Elementor\Repeater();

        $team_items->add_control(
            'name',
            [
                'label' => __('Name', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Kevin martin', 'oxpins-addon'),
                'label_block' => true
            ]
        );

        $team_items->add_control(
            'url',
            [
                'label' => __('Url', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'oxpins-addon'),
                'show_external' => false,
                'default' => [
                    'url' => '',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'show_label' => false,
            ]
        );


        $team_items->add_control(
            'designation',
            [
                'label' => __('Sub Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Volunteer', 'oxpins-addon'),
                'label_block' => true
            ]
        );

        $team_items->add_control(
            'social',
            [
                'label' => __('Social Network', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::CODE,
                'default' => wp_kses(__('<a href="#"><i class="fab fa-facebook"></i></a>', 'oxpins-addon'), 'oxpins_allowed_tags')
            ]
        );


        $team_items->add_control(
            'image',
            [
                'label' => __('Image', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );


        $this->add_control(
            'team_items',
            [
                'label' => __('Team Items', 'oxpins-addon'),
                'prevent_empty' => false,
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $team_items->get_controls(),
                'title_field' => '{{{ name }}}',
            ]
        );

        $this->end_controls_section();

        //style
        $this->start_controls_section(
            'style_options',
            [
                'label' => esc_html__('Style Options', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        oxpins_typo_and_color_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one']);
        oxpins_typo_and_color_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline', ['layout_one']);
        oxpins_typo_and_color_options($this, 'Name', '{{WRAPPER}} .team-one__name,{{WRAPPER}} .team-one__name a', ['layout_one', 'layout_two']);
        oxpins_typo_and_color_options($this, 'Designation', '{{WRAPPER}} .team-one__sub-title', ['layout_one', 'layout_two']);

        $this->end_controls_section();

        oxpins_get_elementor_carousel_options($this, 'layout_three');
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include oxpins_get_template('team-one.php');
        include oxpins_get_template('team-two.php');
        include oxpins_get_template('team-three.php');
    }
}
