<?php

namespace Layerdrops\Oxpins\Widgets;


class Testimonials extends \Elementor\Widget_Base
{
    public function get_name()
    {
        return 'oxpins-testimonials';
    }

    public function get_title()
    {
        return __('Testimonials', 'oxpins-addon');
    }

    public function get_icon()
    {
        return 'eicon-cogs';
    }

    public function get_categories()
    {
        return ['oxpins-category'];
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'layout_section',
            [
                'label' => __('Layout', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => __('Select Layout', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SELECT2,
                'default' => 'layout_one',
                'options' => [
                    'layout_one' => __('Layout One', 'oxpins-addon'),
                    'layout_two' => __('Layout Two', 'oxpins-addon'),
                    'layout_three' => __('Layout Three', 'oxpins-addon'),
                ]
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'content_section',
            [
                'label' => __('Content', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition'   => [
                    'layout_type' => 'layout_one'
                ]
            ]
        );


        $this->add_control(
            'sec_title',
            [
                'label' => __('Section Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Default Sub Text', 'oxpins-addon'),
                'default' => __('Default Text', 'oxpins-addon'),
            ]
        );

        $this->add_control(
            'sec_sub_title',
            [
                'label' => __('Section Sub Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Default Sub Text', 'oxpins-addon'),
                'default' => __('Default Sub Text', 'oxpins-addon'),
            ]
        );

        $this->add_control(
            'summary',
            [
                'label' => __('Summary', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Default Summary Text', 'oxpins-addon'),
                'default' => __('Default Summary', 'oxpins-addon'),
            ]
        );

        $this->add_control(
            'button_label',
            [
                'label' => __('Button Text', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('all testimonials', 'oxpins-addon'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'button_url',
            [
                'label' => __('Button Url', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::URL,
                'placeholder' => __('#', 'oxpins-addon'),
                'show_external' => false,
                'default' => [
                    'url' => '#',
                    'is_external' => false,
                    'nofollow' => false,
                ],
                'show_label' => false,
            ]
        );

        $testimonial = new \Elementor\Repeater();

        $testimonial->add_control(
            'name',
            [
                'label' => __('Name', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Kevin martin', 'oxpins-addon'),
                'label_block' => true
            ]
        );


        $testimonial->add_control(
            'designation',
            [
                'label' => __('Sub Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Volunteer', 'oxpins-addon'),
                'label_block' => true
            ]
        );

        $testimonial->add_control(
            'testimonial',
            [
                'label' => __('Testimonial', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Default Testimonial Content', 'oxpins-addon'),
            ]
        );


        $testimonial->add_control(
            'icon',
            [
                'label' => __('Icon', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'icon-double-quotes',
                    'library' => 'custom-icon',
                ],
            ]
        );

        $testimonial->add_control(
            'image',
            [
                'label' => __('Image', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $testimonial->add_control(
            'shape',
            [
                'label' => __('Shape', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );


        $this->add_control(
            'testimonials',
            [
                'label' => __('Testimonial Items', 'oxpins-addon'),
                'prevent_empty' => false,
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $testimonial->get_controls(),
                'title_field' => '{{{ name }}}',
            ]
        );


        $this->add_control(
            'client_images',
            [
                'label' => __('Client Images', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::GALLERY,
                'default' => [],
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'bg',
            [
                'label' => __('Background', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout_type' => 'layout_one'
                ]
            ]
        );

        $this->add_control(
            'background_image',
            [
                'label' => __('Add Background Image', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
                'condition' => [
                    'layout_type' => 'layout_one'
                ]
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'layout_two_content_section',
            [
                'label' => __('Content', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition'   => [
                    'layout_type' => 'layout_two'
                ]
            ]
        );


        $this->add_control(
            'layout_two_sec_title',
            [
                'label' => __('Section Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Default Sub Text', 'oxpins-addon'),
                'default' => __('Default Text', 'oxpins-addon'),
            ]
        );

        $this->add_control(
            'layout_two_sec_sub_title',
            [
                'label' => __('Section Sub Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Default Sub Text', 'oxpins-addon'),
                'default' => __('Default Sub Text', 'oxpins-addon'),
            ]
        );

        $layout_two_testimonial = new \Elementor\Repeater();

        $layout_two_testimonial->add_control(
            'name',
            [
                'label' => __('Name', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Kevin martin', 'oxpins-addon'),
                'label_block' => true
            ]
        );


        $layout_two_testimonial->add_control(
            'designation',
            [
                'label' => __('Sub Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Volunteer', 'oxpins-addon'),
                'label_block' => true
            ]
        );

        $layout_two_testimonial->add_control(
            'testimonial',
            [
                'label' => __('Testimonial', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Default Testimonial Content', 'oxpins-addon'),
            ]
        );


        $layout_two_testimonial->add_control(
            'rating',
            [
                'label' => __('Rating', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['count'],
                'range' => [
                    'count' => [
                        'min' => 1,
                        'max' => 5,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'count',
                    'size' => 5,
                ],
            ]
        );

        $layout_two_testimonial->add_control(
            'image',
            [
                'label' => __('Image', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $layout_two_testimonial->add_control(
            'shape',
            [
                'label' => __('Shape', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );


        $this->add_control(
            'layout_two_testimonial',
            [
                'label' => __('Testimonial Items', 'oxpins-addon'),
                'prevent_empty' => false,
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $layout_two_testimonial->get_controls(),
                'title_field' => '{{{ name }}}',
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'layout_three_content_section',
            [
                'label' => __('Content', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
                'condition'   => [
                    'layout_type' => 'layout_three'
                ]
            ]
        );


        $this->add_control(
            'layout_three_sec_title',
            [
                'label' => __('Section Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Default Sub Text', 'oxpins-addon'),
                'default' => __('Default Text', 'oxpins-addon'),
            ]
        );

        $this->add_control(
            'layout_three_sec_sub_title',
            [
                'label' => __('Section Sub Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'placeholder' => __('Default Sub Text', 'oxpins-addon'),
                'default' => __('Default Sub Text', 'oxpins-addon'),
            ]
        );

        $layout_three_testimonial = new \Elementor\Repeater();

        $layout_three_testimonial->add_control(
            'name',
            [
                'label' => __('Name', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Kevin martin', 'oxpins-addon'),
                'label_block' => true
            ]
        );


        $layout_three_testimonial->add_control(
            'designation',
            [
                'label' => __('Sub Title', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => __('Volunteer', 'oxpins-addon'),
                'label_block' => true
            ]
        );

        $layout_three_testimonial->add_control(
            'testimonial',
            [
                'label' => __('Testimonial', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => __('Default Testimonial Content', 'oxpins-addon'),
            ]
        );


        $layout_three_testimonial->add_control(
            'rating',
            [
                'label' => __('Rating', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::SLIDER,
                'size_units' => ['count'],
                'range' => [
                    'count' => [
                        'min' => 1,
                        'max' => 5,
                        'step' => 1,
                    ],
                ],
                'default' => [
                    'unit' => 'count',
                    'size' => 5,
                ],
            ]
        );

        $layout_three_testimonial->add_control(
            'icon',
            [
                'label' => __('Icon', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::ICONS,
                'default' => [
                    'value' => 'icon-double-quotes',
                    'library' => 'custom-icon',
                ],
            ]
        );

        $layout_three_testimonial->add_control(
            'image',
            [
                'label' => __('Image', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );

        $layout_three_testimonial->add_control(
            'shape',
            [
                'label' => __('Shape', 'oxpins-addon'),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [],
            ]
        );


        $this->add_control(
            'layout_three_testimonial',
            [
                'label' => __('Testimonial Items', 'oxpins-addon'),
                'prevent_empty' => false,
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $layout_three_testimonial->get_controls(),
                'title_field' => '{{{ name }}}',
            ]
        );


        $this->end_controls_section();


        //style
        $this->start_controls_section(
            'style_options',
            [
                'label' => esc_html__('Style Options', 'oxpins-addon'),
                'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        oxpins_typo_and_color_options($this, 'Section Title', '{{WRAPPER}} .section-title__title', ['layout_one', 'layout_two', 'layout_three']);
        oxpins_typo_and_color_options($this, 'Section Sub Title', '{{WRAPPER}} .section-title__tagline', ['layout_one', 'layout_two', 'layout_three']);
        oxpins_typo_and_color_options($this, 'Summary', '{{WRAPPER}} .testimonial-one__text-1', ['layout_one']);

        oxpins_typo_and_color_options($this, 'Name ', '{{WRAPPER}} .testimonial-one__client-name,{{WRAPPER}} .testimonial-two__client-name,{{WRAPPER}} .testimonial-three__client-name', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);
        oxpins_typo_and_color_options($this, 'Designation ', '{{WRAPPER}} .testimonial-one__client-sub-title,{{WRAPPER}} .testimonial-two__client-sub-title,{{WRAPPER}} .testimonial-three__client-sub-title', ['layout_two', 'layout_three', 'layout_four', 'layout_five']);
        oxpins_typo_and_color_options($this, 'Testimonial ', '{{WRAPPER}} .testimonial-one__text-2, {{WRAPPER}} .testimonial-two__text, {{WRAPPER}} .testimonial-three__text-2', ['layout_one', 'layout_two', 'layout_three', 'layout_four', 'layout_five']);

        oxpins_typo_and_color_options($this, 'Button', '{{WRAPPER}} .thm-btn', ['layout_one']);
        oxpins_typo_and_color_options($this, 'Button Background', '{{WRAPPER}} .thm-btn', ['layout_one'], 'background-color', false);

        $this->end_controls_section();

        oxpins_get_elementor_carousel_options($this, ['layout_one', 'layout_two', 'layout_three', 'layout_five']);
    }

    protected function render()
    {
        $settings = $this->get_settings_for_display();
        include oxpins_get_template('testimonials-one.php');
        include oxpins_get_template('testimonials-two.php');
        include oxpins_get_template('testimonials-three.php');
    }
}
