<?php
get_header(); ?>
<?php
$date = get_post_meta(get_the_ID(), 'oxpins_event_date', true);
$date = date_create($date);
$oxpins_event_category =  get_the_terms(get_the_iD(), 'event_cat');
?>

<!--Event Details Start-->
<section class="event-details">
    <div class="container">
        <div class="row">
            <div class="col-xl-8 col-lg-7">
                <div class="event-details__left">
                    <div class="event-details__top">
                        <div class="event-details__date">
                            <p><?php the_time('d M, Y'); ?></p>
                        </div>
                        <h3 class="event-details__title"><?php the_title(); ?></h3>
                        <?php the_content(); ?>
                        <div class="event-details__btn-box">
                            <a href="<?php echo esc_url(get_post_meta(get_the_ID(), 'oxpins_event_btn_url', true)); ?>" class="thm-btn event-details__btn">
                                <?php echo esc_html(get_post_meta(get_the_ID(), 'oxpins_event_btn_label', true)); ?>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-xl-4 col-lg-5">
                <div class="event-details__right">
                    <div class="event-details__info">
                        <ul class="list-unstyled event-details__info-list ml-0">
                            <li>
                                <span><?php esc_html_e('Time', 'oxpins-addon'); ?>:</span>
                                <p><?php echo esc_html(get_post_meta(get_the_ID(), 'oxpins_event_starting_time', true)); ?><?php esc_html_e(' to ', 'oxpins-addon') ?><?php echo esc_html(get_post_meta(get_the_ID(), 'oxpins_event_end_time', true)); ?></p>
                            </li>
                            <li>
                                <span><?php esc_html_e('Date', 'oxpins-addon'); ?>:</span>
                                <p><?php echo esc_html(date_format($date, "d M, Y")); ?></p>
                            </li>
                            <?php if (!empty($oxpins_event_category)) : ?>
                                <li>
                                    <span><?php esc_html_e('Category', 'oxpins-addon'); ?>:</span>
                                    <p class="event-category">
                                        <?php foreach ($oxpins_event_category as $cat) {
                                            echo '<span>' . esc_attr($cat->name) . '</span>';
                                        } ?>
                                    </p>
                                </li>
                            <?php endif; ?>
                            <li>
                                <span><?php esc_html_e('Location', 'oxpins-addon'); ?>:</span>
                                <p><?php echo esc_html(get_post_meta(get_the_ID(), 'oxpins_event_country', true)); ?></p>
                            </li>
                        </ul>
                        <?php $oxpins_social_network = get_post_meta(get_the_ID(), 'oxpins_event_social_network', true);  ?>
                        <?php if (is_array($oxpins_social_network) && !empty($oxpins_social_network)) : ?>
                            <div class="event-details__social ml-0">
                                <?php foreach ($oxpins_social_network as $item) :  ?>
                                    <?php
                                    $oxpins_event_social_network_fontawesome = '';
                                    if ('yes' == $item['oxpins_event_feature_is_fontawesome']) {
                                        $oxpins_event_social_network_fontawesome = $item['oxpins_event_feature_fontawesome_type'];
                                    }
                                    ?>
                                    <a href="<?php echo esc_url($item['oxpins_event_social_network_url']); ?>"><i class="<?php echo esc_attr($item['oxpins_event_social_network_icon'] . ' ' . $oxpins_event_social_network_fontawesome); ?>"></i></a>
                                <?php endforeach; ?>
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="event-details__map">
                        <?php
                        $url = 'https://maps.google.com/maps?q=%1$s&amp;t=m&amp;z=%2$d&amp;output=embed&amp;iwloc=near';
                        $params = [
                            rawurlencode(get_post_meta(get_the_ID(), 'oxpins_event_map', true)),
                            absint(get_post_meta(get_the_ID(), 'oxpins_event_zoom', true)),
                        ];
                        ?>
                        <iframe src="<?php echo esc_url(vsprintf($url, $params)); ?>"></iframe>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!--Event Details End-->

<?php
get_footer();
