<?php
// Exit if accessed directly
if (!defined('ABSPATH')) exit;


/**
 * Setup My Child Theme's textdomain.
 *
 * Declare textdomain for this child theme.
 * Translations can be filed in the /languages/ directory.
 */
function oxpins_child_theme_setup()
{
    load_child_theme_textdomain('oxpins-child', get_stylesheet_directory() . '/languages');
}
add_action('after_setup_theme', 'oxpins_child_theme_setup');

if (!function_exists('oxpins_child_thm_parent_css')) :
    function oxpins_child_thm_parent_css()
    {
        // loading parent styles
        wp_enqueue_style('oxpins-parent-style', get_template_directory_uri() . '/style.css', array('oxpins-fonts', 'oxpins-icons', 'bootstrap', 'fontawesome'));

        // loading child style based on parent style
        wp_enqueue_style('oxpins-style', get_stylesheet_directory_uri() . '/style.css', array('oxpins-parent-style'));
    }

endif;
add_action('wp_enqueue_scripts', 'oxpins_child_thm_parent_css');

// END ENQUEUE PARENT ACTION