<?php

/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package oxpins
 */

get_header();
?>

<main id="primary" class="site-main">

	<!--Error Page Start-->
	<section class="error-page">
		<?php if (!empty(get_theme_mod('error_page_bg_image'))) : ?>
			<div class="error-page-shape" style="background-image: url(<?php echo esc_url(get_theme_mod('error_page_bg_image')); ?>);"></div>
		<?php endif; ?>
		<div class="container">
			<div class="row">
				<div class="col-xl-12">
					<div class="error-page__inner">
						<div class="error-page__title-box">
							<h2 class="error-page__title"><?php esc_html_e('404', 'oxpins'); ?></h2>
							<h2 class="error-page__title-2"><?php esc_html_e('404', 'oxpins'); ?></h2>
						</div>
						<h3 class="error-page__tagline">
							<?php echo wp_kses(__('Sorry we can\'t find that page <br> you’re looking for.', 'oxpins'), 'oxpins_allowed_tags'); ?>
						</h3>
						<form class="error-page__form" action="<?php echo esc_url(home_url('/')); ?>">
							<div class="error-page__form-input">
								<input type="search" placeholder="<?php esc_attr_e('Search here', 'oxpins'); ?>">
								<button type="submit"><i class="icon-magnifying-glass"></i></button>
							</div>
						</form>
						<a href="<?php echo esc_url(home_url('/')); ?>" class="thm-btn error-page__btn"><?php esc_html_e('back to home', 'oxpins'); ?></a>
					</div>
				</div>
			</div>
		</div>
	</section>
	<!--Error Page End-->


</main><!-- #main -->

<?php
get_footer();
