<?php

/**
 * oxpins functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package oxpins
 */

if (!defined('OXPINS_VERSION')) {
    // Replace the version number of the theme on each release.
    define('OXPINS_VERSION', '1.0');
}

if (!function_exists('oxpins_setup')) :
    /**
     * Sets up theme defaults and registers support for various WordPress features.
     *
     * Note that this function is hooked into the after_setup_theme hook, which
     * runs before the init hook. The init hook is too late for some features, such
     * as indicating support for post thumbnails.
     */
    function oxpins_setup()
    {
        /*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on oxpins, use a find and replace
		 * to change 'oxpins' to the name of your theme in all the template files.
		 */
        load_theme_textdomain('oxpins', get_template_directory() . '/languages');

        // Add default posts and comments RSS feed links to head.
        add_theme_support('automatic-feed-links');

        /*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
        add_theme_support('title-tag');

        // Set post thumbnail size.
        set_post_thumbnail_size(770, 390, true);

        /*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
        add_theme_support('post-thumbnails');

        // This theme uses wp_nav_menu() in one location.
        register_nav_menus(
            array(
                'menu-1' => esc_html__('Primary', 'oxpins'),
            )
        );

        /*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
        add_theme_support(
            'html5',
            array(
                'search-form',
                'comment-form',
                'comment-list',
                'gallery',
                'caption',
                'style',
                'script',
            )
        );


        // Add theme support for selective refresh for widgets.
        add_theme_support('customize-selective-refresh-widgets');

        /**
         * Add support for core custom logo.
         *
         * @link https://codex.wordpress.org/Theme_Logo
         */
        add_theme_support(
            'custom-logo',
            array(
                'height'      => 250,
                'width'       => 250,
                'flex-width'  => true,
                'flex-height' => true,
            )
        );
    }
endif;
add_action('after_setup_theme', 'oxpins_setup');

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function oxpins_content_width()
{
    $GLOBALS['content_width'] = apply_filters('oxpins_content_width', 640);
}
add_action('after_setup_theme', 'oxpins_content_width', 0);

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function oxpins_widgets_init()
{
    register_sidebar(
        array(
            'name'          => esc_html__('Sidebar', 'oxpins'),
            'id'            => 'sidebar-1',
            'description'   => esc_html__('Add widgets here.', 'oxpins'),
            'before_widget' => '<section id="%1$s" class="widget %2$s sidebar__single">',
            'after_widget'  => '</section>',
            'before_title'  => '<h3 class="sidebar__title widget-title">',
            'after_title'   => '</h3>',
        )
    );
}
add_action('widgets_init', 'oxpins_widgets_init');

// google font process

function oxpins_fonts_url()
{
    $font_url = '';

    /*
    Translators: If there are characters in your language that are not supported
    by chosen font(s), translate this to 'off'. Do not translate into your own language.
     */
    if ('off' !== _x('on', 'Google font: on or off', 'oxpins')) {
        $font_url = add_query_arg('family', urlencode('Nunito:200;200i,300,300i,500,500i,600,600i,700,700i,800,800i,900,900i|Manrope:200,200i,300,300i,400i,500,500i,600,600i,700,700i,800,800i|Caveat:400,400i,500,500i,600,600i,700,700i&subset=latin,latin-ext'), "//fonts.googleapis.com/css");
    }

    return esc_url_raw($font_url);
}


/**
 * Enqueue scripts and styles.
 */
function oxpins_scripts()
{
    wp_enqueue_style('oxpins-fonts', oxpins_fonts_url(), array(), null);
    wp_enqueue_style('oxpins-icons', get_template_directory_uri() . '/assets/vendors/oxpins-icons/style.css', array(), '1.0');
    wp_enqueue_style('bootstrap', get_template_directory_uri() . '/assets/vendors/bootstrap/css/bootstrap.min.css', array(), '5.0.0');
    wp_enqueue_style('fontawesome', get_template_directory_uri() . '/assets/vendors/fontawesome/css/all.min.css', array(), '5.15.1');
    wp_enqueue_style('oxpins-style', get_stylesheet_uri(), array(), time());
    wp_style_add_data('oxpins-style', 'rtl', 'replace');


    $oxpins_get_dark_mode_status = get_theme_mod('oxpins_dark_mode', false);

    if (is_page()) {
        $oxpins_get_dark_mode_status = get_post_meta(get_the_ID(), 'oxpins_enable_dark_mode', true);
    }
    $oxpins_dynamic_dark_mode_status = isset($_GET['dark_mode']) ? $_GET['dark_mode'] : $oxpins_get_dark_mode_status;
    if ('yes' == $oxpins_dynamic_dark_mode_status) {
        wp_enqueue_style('oxpins-dark-mode', get_template_directory_uri() . '/assets/css/modes/oxpins-dark.css', array(), time());
    }


    wp_enqueue_script('bootstrap', get_template_directory_uri() . '/assets/vendors/bootstrap/js/bootstrap.min.js', array('jquery'), '5.0.0', true);
    wp_enqueue_script('oxpins-theme', get_template_directory_uri() . '/assets/js/oxpins-theme.js', array('jquery'), time(), true);

    if (is_singular() && comments_open() && get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }
}
add_action('wp_enqueue_scripts', 'oxpins_scripts');


/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';


/**
 * Implement the customizer feature.
 */
if (class_exists('Layerdrops\Oxpins\Customizer')) {;
    require get_template_directory() . '/inc/theme-customizer-styles.php';
}

/**
 * TGMPA Activation.
 */
require get_template_directory() . '/inc/plugins.php';



/*
* one click deomon import
*/
if (class_exists('OCDI_Plugin')) {
    require get_template_directory() . '/inc/demo-import.php';
}
