<?php

/**
 * This template is used to display the login form with [give_login]
 */

$oxpins_give_get_data = give_clean(filter_input_array(INPUT_GET));

if (!is_user_logged_in()) {

	if (!empty($oxpins_give_get_data['donation_id'])) {
		$give_login_redirect = add_query_arg(
			'donation_id',
			$oxpins_give_get_data['donation_id'],
			give_get_history_page_uri()
		);
	}

	// Show any error messages after form submission.
	Give()->notices->render_frontend_notices(0); ?>
	<form id="give-login-form" class="give-form" action="" method="post">
		<?php
		/**
		 * Fires in the login shortcode, before the login fields.
		 *
		 * Allows you to add new fields before the default fields.
		 *
		 * @since 1.0
		 */
		do_action('give_login_fields_before');
		?>
		<div class="col-xl-12 comment-one__login-form">
			<div class="row">
				<div class="col-xl-12">
					<div class="comment-form__input-box">
						<input name="give_user_login" id="give_user_login" type="text" placeholder="<?php echo esc_attr_e('Name/Email Address', 'oxpins'); ?>" required aria-required="true">
					</div>
				</div>
				<div class="col-xl-12">
					<div class="comment-form__input-box">
						<input name="give_user_pass" id="give_user_pass" type="password" placeholder="<?php echo esc_attr_e('Enter Password', 'oxpins'); ?>">
					</div>
				</div>
			</div>
			<div class="row">
				<div class="col-xl-12">
					<div class="comment-form__btn-box text-center">
						<input type="hidden" name="give_login_redirect" value="<?php echo esc_url($give_login_redirect); ?>" />
						<input type="hidden" name="give_login_nonce" value="<?php echo wp_create_nonce('give-login-nonce'); ?>" />
						<input type="hidden" name="give_action" value="user_login" />
						<button type="submit" class="thm-btn comment-form__btn"><?php esc_html_e('Login now', 'oxpins'); ?></button>
					</div>
				</div>
			</div>

		</div>

		<?php
		/**
		 * Fires in the login shortcode, after the login fields.
		 *
		 * Allows you to add new fields after the default fields.
		 *
		 * @since 1.0
		 */
		do_action('give_login_fields_after');
		?>
	</form>
<?php
} elseif (isset($oxpins_give_get_data['give-login-success']) && true === (bool) $oxpins_give_get_data['give-login-success']) {

	Give_Notices::print_frontend_notice(
		apply_filters('give_successful_login_message', esc_html__('Login successful. Welcome!', 'oxpins')),
		true,
		'success'
	);
} else {
	Give_Notices::print_frontend_notice(
		apply_filters(
			'give_already_logged_in_message',
			sprintf(
				/* translators: %s Redirect URL. */
				__('You are already logged in to the site. <a href="%s">Click here</a> to log out.', 'oxpins'),
				esc_url(wp_logout_url())
			)
		),
		true,
		'warning'
	);
}
