<?php

/**
 * The template for displaying form content in the single-give-form.php template
 *
 * Override this template by copying it to yourtheme/give/single-give-form/content-single-give-form.php
 *
 * @package       Give/Templates
 * @version       1.0
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}

/**
 * Fires in single form template, before the form.
 *
 * Allows you to add elements before the form.
 *
 * @since 1.0
 */
do_action('give_before_single_form');

if (post_password_required()) {
	echo get_the_password_form();
	return;
}

global $post;

$oxpins_give_form_id = get_the_ID();
$oxpins_give_form = new Give_Donate_Form($oxpins_give_form_id);
$oxpins_give_progress_stats = give_goal_progress_stats($oxpins_give_form);
$oxpins_give_income = 0;
$oxpins_give_goal = '';


$oxpins_give_goal_option = give_get_meta($oxpins_give_form_id, '_give_goal_option', true);
if ($oxpins_give_goal_option == 'disabled' || !$oxpins_give_goal_option) {
	$oxpins_give_goal = 'Unlimited';
	$pifxoen_give_progress = 100;
	$oxpins_give_income = isset($oxpins_give_progress_stats['actual']) ? $oxpins_give_progress_stats['actual'] : 0;
}

if ($oxpins_give_goal == 'Unlimited') {
	$pifxoen_give_progress_label = esc_html__('Unlimited', 'oxpins');
	$pifxoen_give_progress = 100;
} else {
	$pifxoen_give_progress = isset($oxpins_give_progress_stats['progress']) ? $oxpins_give_progress_stats['progress'] : 100;
	$pifxoen_give_progress_label = $pifxoen_give_progress . '%';
	$oxpins_give_income = isset($oxpins_give_progress_stats['actual']) ? $oxpins_give_progress_stats['actual'] : 0;
	$oxpins_give_goal = isset($oxpins_give_progress_stats['goal']) ? $oxpins_give_progress_stats['goal'] : 0;
	if ($pifxoen_give_progress > 100) $pifxoen_give_progress = 100;
}

$oxpins_give_form_donation_button = get_post_meta(get_the_ID(), 'oxpins_give_form_show_donation_button', true);
$oxpins_give_form_custom_class = ('on' == $oxpins_give_form_donation_button) ? 'oxpins-donate-btn' : 'oxpins-disable-donate-btn';
?>

<div class="content-single-give-form">

	<?php do_action('give_before_single_form'); ?>
	<?php
	if (post_password_required()) {
		echo get_the_password_form();
		return;
	}
	?>
	<div id="give-form-<?php the_ID(); ?>-content" <?php post_class($oxpins_give_form_custom_class); ?>>
		<div class="single-give-images">
			<?php give_show_form_images() ?>
		</div>
		<div class="single-give donation-details__content">
			<div class="<?php echo apply_filters('give_forms_single_summary_classes', 'entry-summary'); ?>">
				<?php if (function_exists('oxpins_get_give_content')) {
					oxpins_get_give_content(get_the_ID());
				} ?>
			</div>
		</div>
		<!-- .summary -->
		<div class="donation-details__donate">
			<div class="donation-details__donate-left">
				<ul class="list-unstyled donation-details__donate-list ml-0">
					<li>
						<div class="icon">
							<span class="icon-solidarity"></span>
						</div>
						<div class="text">
							<span><?php esc_html_e('Raised', 'oxpins'); ?></span>
							<p><?php echo esc_html($oxpins_give_income); ?></p>
						</div>
					</li>
					<li>
						<div class="icon">
							<span class="icon-target-1"></span>
						</div>
						<div class="text">
							<span><?php esc_html_e('Goal', 'oxpins'); ?></span>
							<p><?php echo esc_html($oxpins_give_goal); ?></p>
						</div>
					</li>
				</ul>
			</div>
			<?php if ('on' == $oxpins_give_form_donation_button) : ?>
				<div class="donation-details__donate-btn">
					<?php echo do_shortcode('[give_form id="' . $oxpins_give_form_id . '"  display_style="button" show_title="false"  show_goal="false" show_content="none" ]'); ?>
				</div>
			<?php endif; ?>
		</div>
		<?php
		/**
		 * give_after_single_form_summary hook
		 */
		do_action('give_after_single_form_summary');
		?>
		<?php
		// If comments are open or we have at least one comment, load up the comment template.
		if (comments_open() || get_comments_number()) {
			comments_template();
		}
		?>
	</div>
</div>

<?php do_action('give_after_single_form'); ?>