<?php

/**
 * Single Form Featured Image
 *
 * Displays the featured image for the single donation form - Override this template by copying it to yourtheme/give/single-give-form/featured-image.php
 *
 * @package       Give/Templates
 * @copyright   Copyright (c) 2016, WordImpress
 * @license     https://opensource.org/licenses/gpl-license GNU Public License
 * @since       1.0
 */

if (!defined('ABSPATH')) {
	exit; // Exit if accessed directly.
}
$oxpins_give_category =  get_the_terms(get_the_ID(), 'give_forms_category');
/**
 * Fires in single form template, before the form featured image.
 *
 * Allows you to add elements before the image.
 *
 * @since 1.0
 */
do_action('give_pre_featured_thumbnail');
?>
<?php if (has_post_thumbnail()) : ?>
	<div class="donation-details__img">
		<?php the_post_thumbnail('oxpins_give_form_770X400'); ?>
		<?php if (!is_wp_error($oxpins_give_category) && !empty($oxpins_give_category)) : ?>
			<div class="donation-details__date">
				<p><?php echo esc_html($oxpins_give_category[0]->name); ?></p>
			</div>
		<?php endif; ?>
	</div>
<?php endif; ?>

<?php
/**
 * Fires in single form template, after the form featured image.
 *
 * Allows you to add elements after the image.
 *
 * @since 1.0
 */
do_action('give_post_featured_thumbnail');
?>