<?php

/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package oxpins
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo('charset'); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">

	<?php wp_head(); ?>
	
	<head>
<script src="https://www.google.com/recaptcha/enterprise.js?render=6Lf_qPEnAAAAANIfIJS3Aj9aFaNS9dxOdO9oupvn"></script>
...
</head>

<script>
function onClick(e) {
  e.preventDefault();
  grecaptcha.enterprise.ready(async () => {
    const token = await grecaptcha.enterprise.execute('6Lf_qPEnAAAAANIfIJS3Aj9aFaNS9dxOdO9oupvn', {action: 'LOGIN'});
    // IMPORTANT: The 'token' that results from execute is an encrypted response sent by
    // reCAPTCHA Enterprise to the end user's browser.
    // This token must be validated by creating an assessment.
    // See https://cloud.google.com/recaptcha-enterprise/docs/create-assessment
  });
}
</script>
	
	
	
</head>

<body <?php body_class(); ?>>
	<?php wp_body_open(); ?>
<!--Start of Tawk.to Script-->
<script type="text/javascript">
var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
(function(){
var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
s1.async=true;
s1.src='https://embed.tawk.to/6452fac031ebfa0fe7fbd856/1gvi2701m';
s1.charset='UTF-8';
s1.setAttribute('crossorigin','*');
s0.parentNode.insertBefore(s1,s0);
})();
</script>
<!--End of Tawk.to Script-->
	<?php $oxpins_preloader_status = get_theme_mod('preloader', false); ?>
	<?php if ('yes' == $oxpins_preloader_status) : ?>
		<!-- Preloader -->
		<div class="preloader">
			<div class="preloader__image"></div>
		</div>
	<?php endif; ?>
	<!-- /.preloader -->

	<div id="page" class="site page-wrapper">
		<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e('Skip to content', 'oxpins'); ?></a>

		<?php do_action('oxpins_header'); ?>

		<?php $oxpins_page_header_status = empty(get_post_meta(get_the_ID(), 'oxpins_show_page_banner', true)) ? 'on' : get_post_meta(get_the_ID(), 'oxpins_show_page_banner', true);
		?>

		<?php if (is_page() && 'on' === $oxpins_page_header_status) : ?>
			<?php get_template_part('template-parts/layout/page', 'header'); ?>
		<?php elseif (!is_page()) : ?>
			<?php get_template_part('template-parts/layout/page', 'header'); ?>
		<?php endif; ?>