<?php
function oxpins_demo_import()
{
	return array(
		array(
			'import_file_name'             => 'Oxpins Demo Import',
			'categories'                   => array('oxpins'),
			'import_file_url'              => 'https://layerdrops.com/oxpinswp/tf-data/demo-data/sample-data.xml',
			'import_widget_file_url'       => 'https://layerdrops.com/oxpinswp/tf-data/demo-data/widgets.wie',
			'import_customizer_file_url'   => 'https://layerdrops.com/oxpinswp/tf-data/demo-data/customizer.dat',
			'import_preview_image_url'     => 'https://layerdrops.com/oxpinswp/tf-data/demo-data/preview_import_image1.png',
			'import_notice'                => esc_html__('Please keep patients while importing sample data.', 'oxpins'),
			'preview_url'                  => 'https://layerdrops.com/oxpinswp/',

		),
	);
}
add_filter('pt-ocdi/import_files', 'oxpins_demo_import');

function oxpins_after_import_setup()
{
	// Assign menus to their locations.
	$main_menu = get_term_by('name', 'Main Menu', 'nav_menu');

	set_theme_mod('nav_menu_locations', array(
		'menu-1' => $main_menu->term_id
	));

	// Assign front page and posts page (blog page).
	$front_page_id = get_page_by_title('Home 01');
	$blog_page_id  = get_page_by_title('News sidebar');

	update_option('show_on_front', 'page');
	update_option('page_on_front', $front_page_id->ID);
	update_option('page_for_posts', $blog_page_id->ID);
}
add_action('pt-ocdi/after_import', 'oxpins_after_import_setup');
add_filter('pt-ocdi/disable_pt_branding', '__return_true');
