<?php

/**
 * oxpins functions for getting inline styles from theme customizer
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package oxpins
 */

if (!function_exists('oxpins_theme_customizer_styles')) :
	function oxpins_theme_customizer_styles()
	{

		// oxpins color option

		$oxpins_inline_style = '';
		$oxpins_inline_style .= ':root {
			--oxpins-primary: ' . get_theme_mod('theme_primary_color', sanitize_hex_color('#fbd45a')) . ';
			--oxpins-primary-rgb: ' . oxpins_hex_to_rgb(get_theme_mod('theme_primary_color', sanitize_hex_color('#fbd45a'))) . ';
			--oxpins-base: ' . get_theme_mod('theme_base_color', sanitize_hex_color('#00715d')) . ';
			--oxpins-base-rgb: ' . oxpins_hex_to_rgb(get_theme_mod('theme_base_color', sanitize_hex_color('#00715d'))) . ';
		}';

		$oxpins_inner_banner_bg = get_theme_mod('page_header_bg_image');
		$oxpins_inline_style .= '.page-header-bg { background-image: url(' . $oxpins_inner_banner_bg . '); } ';

		$oxpins_preloader_icon = get_theme_mod('preloader_image');
		if ($oxpins_preloader_icon) {
			$oxpins_inline_style .= '.preloader .preloader__image { background-image: url(' . $oxpins_preloader_icon . '); } ';
		}

		if (is_page()) {


			$oxpins_page_primary_color = empty(get_post_meta(get_the_ID(), 'oxpins_primary_color', true)) ? get_theme_mod('oxpins_primary_color', sanitize_hex_color('#fbd45a')) : get_post_meta(get_the_ID(), 'oxpins_primary_color', true);

			$oxpins_page_base_color = empty(get_post_meta(get_the_ID(), 'oxpins_base_color', true)) ? get_theme_mod('theme_base_color', sanitize_hex_color('#00715d')) : get_post_meta(get_the_ID(), 'oxpins_base_color', true);

			$oxpins_inline_style .= ':root {
				--oxpins-primary: ' . $oxpins_page_primary_color . ';
				--oxpins-primary-rgb: ' . oxpins_hex_to_rgb($oxpins_page_primary_color) . ';
				--oxpins-base: ' . $oxpins_page_base_color . ';
				--oxpins-base-rgb: ' . oxpins_hex_to_rgb($oxpins_page_base_color) . ';
			}';

			$oxpins_page_header_bg = empty(get_post_meta(get_the_ID(), 'oxpins_set_header_image', true)) ? get_theme_mod('page_header_bg_image') : get_post_meta(get_the_ID(), 'oxpins_set_header_image', true);

			$oxpins_inline_style .= '.page-header-bg { background-image: url(' . $oxpins_page_header_bg . '); }';
		}


		wp_add_inline_style('oxpins-style', $oxpins_inline_style);
	}
endif;

add_action('wp_enqueue_scripts', 'oxpins_theme_customizer_styles');
