<?php
get_header();
$oxpins_organizer_name = get_post_meta(get_the_ID(), 'oxpins_give_form_organizer_name', true);
$oxpins_organizer_location = get_post_meta(get_the_ID(), 'oxpins_give_form_organizer_location', true);
$oxpins_organizer_image = get_post_meta(get_the_ID(), 'oxpins_give_form_organizer_image', true);
$oxpins_give_category =  get_the_terms(get_the_ID(), 'give_forms_category');
?>

<!--Donation Details Start-->
<section class="donation-details">
    <div class="container">
        <div class="row">
            <div class="col-xl-8 col-lg-7">
                <?php while (have_posts()) :
                    the_post(); ?>
                <?php give_get_template_part('single-give-form/content', 'single-give-form');

                endwhile; ?>
            </div>
            <div class="col-xl-4 col-lg-5">
                <div class="donation-details__sidebar">
                    <div class="donation-details__organizer">
                        <?php if (!empty($oxpins_organizer_name || !empty($oxpins_organizer_location) || $oxpins_organizer_image)) : ?>
                            <div class="donation-details__organizer-img">
                                <img src="<?php echo esc_url($oxpins_organizer_image); ?>" alt="<?php echo esc_attr(bloginfo('name')); ?>">
                            </div>
                            <div class="donation-details__organizer-content">
                                <p class="donation-details__organizer-date"><?php esc_html_e('Created', 'oxpins'); ?> <?php the_time('d M, Y'); ?></p>
                                <p class="donation-details__organizer-title"><?php esc_html_e('Organizer', 'oxpins'); ?>:</p>
                                <p class="donation-details__organizer-name"><?php echo esc_html($oxpins_organizer_name); ?></p>
                                <ul class="list-unstyled donation-details__organizer-list">
                                    <?php if (!is_wp_error($oxpins_give_category) && !empty($oxpins_give_category)) : ?>
                                        <li>
                                            <div class="icon">
                                                <span class="fas fa-tag"></span>
                                            </div>
                                            <div class="text">
                                                <p><?php echo esc_html($oxpins_give_category[0]->name); ?></p>
                                            </div>
                                        </li>
                                    <?php endif; ?>

                                    <li>
                                        <div class="icon">
                                            <span class="fas fa-map-marker-alt"></span>
                                        </div>
                                        <div class="text">
                                            <p><?php echo esc_html($oxpins_organizer_location); ?></p>
                                        </div>
                                    </li>

                                </ul>
                            </div>
                        <?php endif; ?>
                    </div>
                    <?php get_sidebar('givewp'); ?>
                </div>
            </div>
        </div>
    </div>
</section>
<!--Donation Details End-->
<?php
get_footer();
