<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package oxpins
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class('news-sidebar__single'); ?>>

	<?php oxpins_post_thumbnail(); ?>

	<div class="news-sidebar__content-box">
		<ul class="list-unstyled news-sidebar__meta ml-0">
			<li><?php oxpins_posted_by(); ?></li>
			<?php if (!is_single() && !post_password_required() && (comments_open() || get_comments_number())) : ?>
				<li><?php oxpins_comment_count(); ?></li>
			<?php endif; ?>
		</ul>
		<h3 class="news-sidebar__title">
			<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
		</h3>
		<?php $oxpins_excerpt_count = apply_filters('oxpins_excerpt_count', 39); ?>
		<p class="news-sidebar__text"><?php oxpins_excerpt($oxpins_excerpt_count); ?></p>
		<div class="news-sidebar__bottom">
			<a href="<?php the_permalink(); ?>" class="news-sidebar__arrow"><span class="icon-right-arrow"></span></a>
			<a href="<?php the_permalink(); ?>" class="news-sidebar__read-more"><?php esc_html_e('Read More', 'oxpins'); ?></a>
		</div>
	</div>

</article><!-- #post-<?php the_ID(); ?> -->