<?php

/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package oxpins
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

	<?php oxpins_post_thumbnail(); ?>

	<div class="news-details__content blog-details__content clearfix">
		<ul class="list-unstyled news-details__meta ml-0">

			<li><?php oxpins_posted_by(); ?></li>

			<li><?php oxpins_comment_count(); ?></li>

		</ul>
		<?php
		the_content(
			sprintf(
				wp_kses(
					/* translators: %s: Name of current post. Only visible to screen readers */
					esc_html__('Continue reading', 'oxpins') . '<span class="screen-reader-text"> "%s"</span>',
					array(
						'span' => array(
							'class' => array(),
						),
					)
				),
				wp_kses_post(get_the_title())
			)
		);

		wp_link_pages(
			array(
				'before' => '<div class="page-links">' . esc_html__('Pages:', 'oxpins'),
				'after'  => '</div>',
			)
		);
		?>
	</div>
	<div class="news-details__bottom">
		<?php oxpins_entry_footer(); ?>
	</div>

</article><!-- #post-<?php the_ID(); ?> -->