<?php

/**
 * Template part for displaying footer
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package oxpins
 */
?>


<?php
$oxpins_page_id     = get_queried_object_id();
$oxpins_custom_footer_status = !empty(get_post_meta($oxpins_page_id, 'oxpins_custom_footer_status', true)) ? get_post_meta($oxpins_page_id, 'oxpins_custom_footer_status', true) : 'off';

$oxpins_custom_footer_id = '';
if ((is_page() && 'on' === $oxpins_custom_footer_status) || (is_singular('portfolio') && 'on' === $oxpins_custom_footer_status) || (is_singular('service') && 'on' === $oxpins_custom_footer_status)) {
	$oxpins_custom_footer_id = get_post_meta($oxpins_page_id, 'oxpins_select_custom_footer', true);
} elseif (true == get_theme_mod('footer_custom')) {
	$oxpins_custom_footer_id = get_theme_mod('footer_custom_post');
} else {
	$oxpins_custom_footer_id = 'default_footer';
}

$oxpins_dynamic_footer = isset($_GET['custom_footer_id']) ? $_GET['custom_footer_id'] : $oxpins_custom_footer_id;
?>


<?php if ('default_footer' == $oxpins_dynamic_footer) : ?>

	<footer class="site-footer default-footer text-center">
		<div class="site-footer__bottom">
			<div class="container">
				<div class="row">
					<div class="col-xl-12">
						<div class="site-footer__bottom-inner">
							<p class="site-footer__bottom-text"><?php echo wp_kses(get_theme_mod('footer_copytext', esc_html__('&copy; Copyright 2022 by Layerdrops.com', 'oxpins')), 'oxpins_allowed_tags'); ?>
							</p>
						</div>
					</div>
				</div>
			</div>
		</div>
	</footer>

<?php else : ?>
	<?php echo do_shortcode('[oxpins-footer id="' . $oxpins_dynamic_footer . '"]');
	?>
<?php endif; ?>